---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-Master Environment（マスター環境情報）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **SparkEnv.environmentDetailsの戻り値構造**：SparkEnv.scalaの直接読み込みは行っていないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/master/ui/EnvironmentPage.scala`（161行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala`（135行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/environment/` | E-01 (33行目: `WebUIPage("Environment")`), E-02 (60-62行目: `createServletHandler("/environment"...)`) | ○ |
| C-02 | 7セクション（JVM, Spark, Hadoop, System, Metrics, Classpath, Env Vars）を表示 | E-01 (38-46行目, 63-146行目) | ○ |
| C-03 | Sparkプロパティに機密値マスク処理 | E-01 (39行目: `Utils.redact(conf, details("Spark Properties"))`) | ○ |
| C-04 | Hadoopプロパティに機密値マスク処理 | E-01 (40行目: `Utils.redact(conf, details("Hadoop Properties"))`) | ○ |
| C-05 | システムプロパティに機密値マスク処理 | E-01 (41行目: `Utils.redact(conf, details("System Properties"))`) | ○ |
| C-06 | メトリクスプロパティに機密値マスク処理 | E-01 (42行目: `Utils.redact(conf, details("Metrics Properties"))`) | ○ |
| C-07 | 環境変数はプレフィックスフィルタ適用 | E-01 (44-46行目: `MASTER_UI_VISIBLE_ENV_VAR_PREFIXES`, `prefixes.exists(k.startsWith(_))`) | ○ |
| C-08 | Runtime InformationとSpark Propertiesは初期展開 | E-01 (69行目, 80行目: `arrow-open`) | ○ |
| C-09 | その他のセクションは初期折りたたみ | E-01 (94, 106, 114, 124, 135行目: `arrow-closed`, `collapsed`) | ○ |
| C-10 | Back to Masterリンク | E-01 (65行目: `<a href="/">Back to Master</a>`) | ○ |
| C-11 | environmentpage.jsを読み込み | E-01 (145行目) | ○ |
| C-12 | 全プロパティをソートして表示 | E-01 (38-43行目: `.sorted`) | ○ |
| C-13 | EnvironmentPageは2重登録（WebUIPage + ServletHandler） | E-02 (59-62行目) | ○ |
| C-14 | SparkEnv.environmentDetailsの戻り値構造 | **根拠なし**（SparkEnv.scalaを直接読んでいない） | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: SparkEnv.environmentDetailsのMapキー名と内容の正確な構造はSparkEnv.scalaの確認が必要
  - 候補：core/src/main/scala/org/apache/spark/SparkEnv.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EnvironmentPage.scalaの使用箇所から構造は推定可能

## 6) レビュアーチェックリスト（最小）
- [ ] SparkEnv.environmentDetailsの戻り値キーが正確か確認
- [ ] Utils.redactのマスク対象キーワードパターンが正確か確認
- [ ] MASTER_UI_VISIBLE_ENV_VAR_PREFIXESのデフォルト値を確認
